
%% Matlab Code for generating Gaussian white noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;
%% Load 10 identical simulated Hoevers coarse crackles here
load SC1_Hoevers
load SC2_Hoevers
load SC3_Hoevers
load SC4_Hoevers
load SC5_Hoevers
load SC6_Hoevers
load SC7_Hoevers
load SC8_Hoevers
load SC9_Hoevers
load SC10_Hoevers
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SC1_Hoevers     = [zeros(1,1000),SC1_Hoevers,zeros(1,Signal_length-(1000+length(SC1_Hoevers)))];
SC2_Hoevers     = [zeros(1,3000),SC2_Hoevers,zeros(1,Signal_length-(3000+length(SC2_Hoevers)))];
SC3_Hoevers     = [zeros(1,7000),SC3_Hoevers,zeros(1,Signal_length-(7000+length(SC3_Hoevers)))];
SC4_Hoevers     = [zeros(1,12000),SC4_Hoevers,zeros(1,Signal_length-(12000+length(SC4_Hoevers)))];
SC5_Hoevers     = [zeros(1,14000),SC5_Hoevers,zeros(1,Signal_length-(14000+length(SC5_Hoevers)))];
SC6_Hoevers     = [zeros(1,17000),SC6_Hoevers,zeros(1,Signal_length-(17000+length(SC6_Hoevers)))];
SC7_Hoevers     = [zeros(1,20000),SC7_Hoevers,zeros(1,Signal_length-(20000+length(SC7_Hoevers)))];
SC8_Hoevers     = [zeros(1,23000),SC8_Hoevers,zeros(1,Signal_length-(23000+length(SC8_Hoevers)))];
SC9_Hoevers     = [zeros(1,27500),SC9_Hoevers,zeros(1,Signal_length-(27500+length(SC9_Hoevers)))];
SC10_Hoevers    = [zeros(1,30000),SC10_Hoevers,zeros(1,Signal_length-(30000+length(SC10_Hoevers)))];
Ten_identical_simulated_Hoevers_coarse_crackles         = SC1_Hoevers+SC2_Hoevers+SC3_Hoevers+SC4_Hoevers+SC5_Hoevers+SC6_Hoevers+SC7_Hoevers+SC8_Hoevers+SC9_Hoevers+SC10_Hoevers;
Ten_identical_simulated_Hoevers_coarse_crackles         = Ten_identical_simulated_Hoevers_coarse_crackles(1:end);                                                            
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop        = -10:1:10                                                 %% Start signal to noise ratio loop
for iterative_loop  = 1:201                                                    %% Start number of iterations loop 
%% Generate Gaussian white noise
Signal       = awgn(Ten_identical_simulated_Hoevers_coarse_crackles,SNR_loop,'measured');   %% Signal with 10 identical Hoevers coarse crackles buried under Gaussian white noise
                                                                 

%% Use your separation technique here


end
end